// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 12, Aufgabe 4
// "Doppelt verkettete Liste"

class Node {
	int val;
	Node next, prev;
	Node(int v) { val = v; next = null; prev = null; }
}

// A doubly linked sorted list
class List {
	Node head = null, tail = null;
	
	void insert(int val) {
		Node p = head;
		if (head == null)
			head = tail = new Node(val);
		else {
			while (p != null && val > p.val) p = p.next;
			// p == null || val <= p.val
			if (p == null) {
				p = new Node(val);
				tail.next = p; p.prev = tail; tail = p;
			} else { // insert val before p
				Node q = new Node(val);
				q.next = p; q.prev = p.prev;
				if (p == head) head = q; else p.prev.next = q;
				p.prev = q;
			}
		}
	}
	
	void delete(int val) {
		Node p = head;
		while (p != null && val > p.val) p = p.next;
		// p == null || val <= val
		if (p != null && val == p.val) {
			if (p == head) {
				head = p.next;
				if (head == null) tail = null; else head.prev = null;
			} else if (p.next == null) {
				tail = p.prev; tail.next = null;
			} else {
				p.prev.next = p.next;
				p.next.prev = p.prev;
			}
		}
	}

	void print() {
		for (Node p = head; p != null; p = p.next) Out.print(p.val + " ");
		Out.println();
	}

}
	
public class A4 {
	
	// Read a sequence of integers and link them into a list
	static List readList() {
		List list = new List();
		int val = In.readInt();
		while (In.done()) {
			list.insert(val);
			val = In.readInt();
		}
		return list;
	}
	
	// Read a sequence of integers and remove them from the list
	static void removeElements(List list) {
		In.readWord(); // skip separator
		int val = In.readInt();
		while (In.done()) {
			list.delete(val);
			list.print();
			val = In.readInt();
		}
	}
	
	public static void main(String args[]) {
		In.open("input.txt");
		List list = readList();
		list.print();
		removeElements(list);
		In.close();
	}
}

/*
Sample input:
34 5 23 56 7 87 45 3 56 6 34
REMOVE
23 7 8 56
*/